import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../../store';
import { MvpServices } from '../../../../services/mvp-services';

@Component({
  selector: 'app-mvp-add-sub-classes',
  templateUrl: './mvp-add-sub-classes.component.html',
  styleUrls: ['./mvp-add-sub-classes.component.scss']
})
export class MvpAddSubClassesComponent implements OnInit {
  @Input() tindex;
  @Input() tabType;
  @Input() mvpObject;
  newName;
  onHoverSubmit: boolean;
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    public mvpServices: MvpServices) { }

  ngOnInit() {
  }

  addSubClass(){
    var subClassInput = this.newName.trim();
    if (subClassInput != null && subClassInput.length > 0) {
      this.mvpObject.input = subClassInput;
      this.mvpServices.addMvpConcept(this.mvpObject, this.tabType);
    }
  }

}
